/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawner;
import dev.toma.gunsrpg.common.quests.quest.area.QuestAreaScheme;
import dev.toma.gunsrpg.util.math.Vec2i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class QuestArea {
    public static final ITextComponent STAY_IN_AREA = new TranslationTextComponent("quest.stay_in_area");
    public static final ITextComponent INTERACTION_DISABLED = new TranslationTextComponent("quest.interaction_blocked").func_240699_a_(TextFormatting.RED);
    private final QuestAreaScheme scheme;
    private final BlockPos pos;
    private final Vec2i cornerA;
    private final Vec2i cornerB;
    private int spawnIntervalTimer;
    private boolean isActiveArea;
    private Collection<ParticleEntry> edgePositions;

    public QuestArea(QuestAreaScheme scheme, BlockPos pos) {
        this.scheme = scheme;
        this.pos = pos;
        this.spawnIntervalTimer = scheme.getSpawnInterval();
        int radius = scheme.getSize();
        this.cornerA = new Vec2i(pos.func_177958_n() - radius, pos.func_177952_p() - radius);
        this.cornerB = new Vec2i(pos.func_177958_n() + radius + 1, pos.func_177952_p() + radius + 1);
    }

    public BlockPos getCenter() {
        return this.pos;
    }

    public static QuestArea fromNbt(QuestAreaScheme scheme, CompoundNBT nbt) {
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
        int spawnDelay = nbt.func_74762_e("spawnDelay");
        boolean isActive = nbt.func_74767_n("activeArea");
        QuestArea area = new QuestArea(scheme, pos);
        area.spawnIntervalTimer = spawnDelay;
        area.isActiveArea = isActive;
        return area;
    }

    public void tickArea(World world, PlayerEntity player) {
        this.isActiveArea = true;
        if (!world.field_72995_K) {
            if (--this.spawnIntervalTimer < 0) {
                this.spawnIntervalTimer = this.scheme.getSpawnInterval();
                IMobSpawner spawner = this.scheme.getSpawner();
                spawner.spawnMobsRandomly(world, this, player);
            }
        } else {
            if (this.edgePositions == null) {
                this.fillEdgePositions(world);
            }
            if (world.func_72820_D() % 10L == 0L) {
                this.edgePositions.forEach(particle -> particle.makeParticles(world));
            }
        }
    }

    public QuestAreaScheme getScheme() {
        return this.scheme;
    }

    public boolean isActiveArea() {
        return this.isActiveArea;
    }

    public BlockPos getRandomEgdePosition(Random random, World world) {
        int mode = random.nextInt(4);
        int minX = this.cornerA.x();
        int minZ = this.cornerA.y();
        int maxX = this.cornerB.x();
        int maxZ = this.cornerB.y();
        switch (mode) {
            case 0: {
                int z = minZ + random.nextInt(maxZ - minZ + 1);
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, minX, z);
                return new BlockPos(minX, y, z);
            }
            case 1: {
                int x = minX + random.nextInt(maxX - minX + 1);
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, minZ);
                return new BlockPos(x, y, minZ);
            }
            case 2: {
                int z = minZ + random.nextInt(maxZ - minZ + 1);
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, maxX, z);
                return new BlockPos(maxX, y, z);
            }
        }
        int x = minX + random.nextInt(maxX - minX + 1);
        int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, maxZ);
        return new BlockPos(minX, y, maxZ);
    }

    public boolean isInArea(Entity entity) {
        double x = entity.func_226277_ct_();
        double z = entity.func_226281_cx_();
        return this.isInArea(x, z);
    }

    public boolean isInArea(double x, double z) {
        return x >= (double)this.cornerA.x() && z >= (double)this.cornerA.y() && x <= (double)this.cornerB.x() && z <= (double)this.cornerB.y();
    }

    public double getDistance(Entity entity) {
        double x = (double)this.pos.func_177958_n() - entity.func_226277_ct_();
        double z = (double)this.pos.func_177952_p() - entity.func_226281_cx_();
        return Math.sqrt(x * x + z * z);
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        nbt.func_74768_a("spawnDelay", this.spawnIntervalTimer);
        nbt.func_74757_a("activeArea", this.isActiveArea);
        return nbt;
    }

    private void fillEdgePositions(World world) {
        int i;
        this.edgePositions = new ArrayList<ParticleEntry>();
        int minX = this.cornerA.x();
        int minZ = this.cornerA.y();
        int maxX = this.cornerB.x();
        int maxZ = this.cornerB.y();
        this.edgePositions.add(ParticleEntry.corner(new Vector3i(minX, this.height(world, minX, minZ), minZ)));
        this.edgePositions.add(ParticleEntry.corner(new Vector3i(minX, this.height(world, minX, maxZ), maxZ)));
        this.edgePositions.add(ParticleEntry.corner(new Vector3i(maxX, this.height(world, maxX, minZ), minZ)));
        this.edgePositions.add(ParticleEntry.corner(new Vector3i(maxX, this.height(world, maxX, maxZ), maxZ)));
        for (i = minX + 1; i < maxX; i += 3) {
            this.edgePositions.add(ParticleEntry.edge(new Vector3i(i, this.height(world, i, minZ), minZ)));
            this.edgePositions.add(ParticleEntry.edge(new Vector3i(i, this.height(world, i, maxZ), maxZ)));
        }
        for (i = minZ + 1; i < maxZ; i += 3) {
            this.edgePositions.add(ParticleEntry.edge(new Vector3i(minX, this.height(world, minX, i), i)));
            this.edgePositions.add(ParticleEntry.edge(new Vector3i(maxX, this.height(world, maxX, i), i)));
        }
        ArrayList<ParticleEntry> blocksBelow = new ArrayList<ParticleEntry>();
        for (ParticleEntry entry : this.edgePositions) {
            Vector3i vec = entry.vec;
            BlockPos.Mutable mutable = new BlockPos.Mutable(vec.func_177958_n(), vec.func_177956_o() - 1, vec.func_177952_p());
            while (mutable.func_177956_o() > 0) {
                boolean air = world.func_175623_d((BlockPos)mutable);
                mutable.func_185336_p(mutable.func_177956_o() - 1);
                if (!air || world.func_175623_d((BlockPos)mutable)) continue;
                blocksBelow.add(entry.copy((Vector3i)mutable.func_177984_a()));
            }
        }
        this.edgePositions.addAll(blocksBelow);
    }

    private int height(World world, int x, int z) {
        return world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
    }

    private static final class ParticleEntry {
        private final IParticleData data;
        private final Vector3i vec;
        private final float power;

        public ParticleEntry(IParticleData data, Vector3i vec, float power) {
            this.data = data;
            this.vec = vec;
            this.power = power;
        }

        public ParticleEntry copy(Vector3i vector3i) {
            return new ParticleEntry(this.data, vector3i, this.power);
        }

        public static ParticleEntry corner(Vector3i vec) {
            return new ParticleEntry((IParticleData)ParticleTypes.field_197613_f, vec, 0.3f);
        }

        public static ParticleEntry edge(Vector3i vec) {
            return new ParticleEntry((IParticleData)ParticleTypes.field_197613_f, vec, 0.05f);
        }

        public void makeParticles(World world) {
            world.func_195590_a(this.data, true, (double)this.vec.func_177958_n() + 0.5, (double)this.vec.func_177956_o(), (double)this.vec.func_177952_p() + 0.5, 0.0, (double)this.power, 0.0);
        }
    }
}

